/*
 * Decompiled with CFR 0.152.
 */
package jace.hardware.mockingboard;

import jace.hardware.mockingboard.Card;
import jace.hardware.mockingboard.EnvelopeGenerator;
import jace.hardware.mockingboard.NoiseGenerator;
import jace.hardware.mockingboard.SoundGenerator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PSG {
    Map<Card.Reg, Integer> registers;
    List<SoundGenerator> channels;
    EnvelopeGenerator envelopeGenerator;
    NoiseGenerator noiseGenerator;
    int CLOCK;
    int SAMPLE_RATE;

    public PSG(int clock, int sample_rate) {
        this.CLOCK = clock;
        this.SAMPLE_RATE = sample_rate;
        this.registers = new HashMap<Card.Reg, Integer>();
        for (Card.Reg r : Card.Reg.values()) {
            this.setReg(r, 0);
        }
        this.channels = new ArrayList<SoundGenerator>();
        for (int i = 0; i < 3; ++i) {
            this.channels.add(new SoundGenerator(clock, sample_rate));
        }
        this.envelopeGenerator = new EnvelopeGenerator(clock, sample_rate);
        this.noiseGenerator = new NoiseGenerator(clock, sample_rate);
    }

    public void reset() {
        for (SoundGenerator c : this.channels) {
            c.reset();
        }
        this.envelopeGenerator.reset();
        this.noiseGenerator.reset();
        for (Card.Reg r : Card.Reg.values()) {
            this.writeReg(r, 0);
        }
    }

    public void setReg(Card.Reg r, int value) {
        this.registers.put(r, value);
    }

    public int getReg(Card.Reg r) {
        return this.registers.get((Object)r);
    }

    public void writeReg(Card.Reg r, int value) {
        this.setReg(r, value &= r.max);
        switch (r) {
            case ACoarse: 
            case AFine: {
                this.channels.get(0).setPeriod(this.getReg(Card.Reg.AFine) + 256 * this.getReg(Card.Reg.ACoarse));
                break;
            }
            case BCoarse: 
            case BFine: {
                this.channels.get(1).setPeriod(this.getReg(Card.Reg.BFine) + 256 * this.getReg(Card.Reg.BCoarse));
                break;
            }
            case CCoarse: 
            case CFine: {
                this.channels.get(2).setPeriod(this.getReg(Card.Reg.CFine) + 256 * this.getReg(Card.Reg.CCoarse));
                break;
            }
            case NoisePeriod: {
                this.noiseGenerator.setPeriod(value);
                break;
            }
            case Enable: {
                this.channels.get(0).setActive((value & 1) == 0);
                this.channels.get(0).setNoiseActive((value & 8) == 0);
                this.channels.get(1).setActive((value & 2) == 0);
                this.channels.get(1).setNoiseActive((value & 0x10) == 0);
                this.channels.get(2).setActive((value & 4) == 0);
                this.channels.get(2).setNoiseActive((value & 0x20) == 0);
                break;
            }
            case AVol: {
                this.channels.get(0).setAmplitude(value);
                break;
            }
            case BVol: {
                this.channels.get(1).setAmplitude(value);
                break;
            }
            case CVol: {
                this.channels.get(2).setAmplitude(value);
                break;
            }
            case EnvFine: 
            case EnvCoarse: {
                this.envelopeGenerator.setPeriod(this.getReg(Card.Reg.EnvFine) + 256 * this.getReg(Card.Reg.EnvCoarse));
                break;
            }
            case EnvShape: {
                this.envelopeGenerator.setShape(value);
                break;
            }
        }
    }

    void update(int[][] buffer, int length) {
        int[] buf1 = buffer[0];
        int[] buf2 = buffer[1];
        int[] buf3 = buffer[2];
        for (int i = 0; i < length; ++i) {
            this.noiseGenerator.step();
            this.envelopeGenerator.step();
            buf1[i] = this.channels.get(0).step(this.noiseGenerator, this.envelopeGenerator);
            buf2[i] = this.channels.get(1).step(this.noiseGenerator, this.envelopeGenerator);
            buf3[i] = this.channels.get(2).step(this.noiseGenerator, this.envelopeGenerator);
        }
    }
}

